package jadean.test.dean.java.utilities;

import jadean.dean.java.utilities.JavaUtilities;

import java.util.ArrayList;

import junit.framework.Assert;

import org.junit.After;
import org.junit.AfterClass;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Test;


public class JavaUtilitiesTest {

	@BeforeClass
	public static void setUpBeforeClass() throws Exception {
	}

	@AfterClass
	public static void tearDownAfterClass() throws Exception {
	}

	@Before
	public void setUp() throws Exception {
	}

	@After
	public void tearDown() throws Exception {
	}

	@Test
	public void testArrayToList() {
		String[] inputArray = {"1", "2", "3", "4"};
		ArrayList<String> expectedResult = new ArrayList<String>();
		expectedResult.add("1");
		expectedResult.add("2");
		expectedResult.add("3");
		expectedResult.add("4");
		
		ArrayList<String> realResult = JavaUtilities.arrayToList(inputArray);
		
		Assert.assertTrue(expectedResult.containsAll(realResult));
		Assert.assertTrue(realResult.containsAll(expectedResult));
	}

	@Test
	public void testIsAtomicClassName() {
		Assert.assertTrue(JavaUtilities.isAtomicClassName("abc"));
		Assert.assertTrue(JavaUtilities.isAtomicClassName("Abc"));
		Assert.assertTrue(JavaUtilities.isAtomicClassName("ABC"));
		Assert.assertTrue(JavaUtilities.isAtomicClassName("aBc"));
		Assert.assertFalse(JavaUtilities.isAtomicClassName("a.aBc"));
		Assert.assertFalse(JavaUtilities.isAtomicClassName("a.a.a"));
		Assert.assertFalse(JavaUtilities.isAtomicClassName("a.a.Main"));
	}

	@Test
	public void testBuildFullyQualifiedClassName() {
		Assert.assertEquals("a.b.A", JavaUtilities.buildFullyQualifiedClassName("a.b", "A"));
		Assert.assertEquals("a.A", JavaUtilities.buildFullyQualifiedClassName("a", "A"));
		Assert.assertEquals("A", JavaUtilities.buildFullyQualifiedClassName("", "A"));
	}

	@Test
	public void testExtractPackage() {
		Assert.assertEquals("a.b", JavaUtilities.extractPackage("a.b.A"));
		Assert.assertEquals("a", JavaUtilities.extractPackage("a.A"));
		Assert.assertEquals("", JavaUtilities.extractPackage("A"));
	}

	@Test
	public void testExtractClassName() {
		Assert.assertEquals("A", JavaUtilities.extractClassName("a.b.A"));
		Assert.assertEquals("A", JavaUtilities.extractClassName("a.A"));
		Assert.assertEquals("A", JavaUtilities.extractClassName("A"));
	}

}
